/**
  @file Firmware.ino
  @author Saulo Daniel Ferreira Pontes
  @version 1.3 07/2015

  Arquivo principal do firmware do arduino
*/

#include <Arduino.h>
#include <string.h>

#include "EEPROM.h"
#include "TaskScheduler.h"

#include "config.h"
#include "scommp.h"
#include "device.h"

//Gerador de dados aleatorios
#include "random_driver.h"

//Dispositivos da Estacao
#include "DHT22_driver.h"
#include "LDR_GL5528_driver.h"
#include "TP_401A_driver.h"
#include "GUVA_S12D_driver.h"
#include "bucket_rain_gauge_driver.h"
#include "BMP085_driver.h"
//#include "SIM28_driver.h"

//! Tempo em que o ultimo caractere for recebido
long lastcharTime = 0;

//! Modulo de comunicacao SCOMMP
SCOMMP scommp;

//dispositivos
random_driver random_1;

DHT22_Sensor DHT22_1;
LDR_GL5528_Sensor LDR_GL5528_1;
TP_401A_Sensor TP_401A_1;
GUVA_S12D_Sensor GUVA_S12D_1;
Bucket_Rain_Gauge_Sensor Bucket_Rain_Gauge_1;
BMP085_Sensor BMP085_1;
//SIM28_Sensor SIM28_1;

//! temporizadores =============
Scheduler runner;

//task de requisição de auto registro
Task t0(10000, -1, &registrationRequest);

//task de upadate do random_1
//Task tr(10000, -1, &trCallback);
//
//void trCallback() {
//  random_1.update();
//}

//task de upadate do DHT22_1
Task t1(50000, -1, &t1Callback);

void t1Callback() {
  DHT22_1.update();
}

//task de upadate do TP_401A_1
Task t2(10000, -1, &t2Callback);

void t2Callback() {
  LDR_GL5528_1.update();
}

//task de upadate do LDR_GL5528_1
Task t3(10000, -1, &t3Callback);

void t3Callback() {
  TP_401A_1.update();
}

//task de upadate do GUVA_S12D_1
Task t4(10000, -1, &t4Callback);

void t4Callback() {
  GUVA_S12D_1.update();
}

//task de upadate do Bucket_Rain_Gauge_1
Task t5(10, -1, &t5Callback);

void t5Callback() {
  Bucket_Rain_Gauge_1.update();
}

//task de upadate do  BMP085_1
Task t6(10000, -1, &t6Callback);

void t6Callback() {
  BMP085_1.update();
}

////task de upadate do SIM28_1
//Task t7(10000, -1, &t7Callback);
//
//void t7Callback() {
//  SIM28_1.update();
//}


void registrationRequest()
{
  //! Assim que o microcontrolaodor e reiniciado tenta validar 
  //! o registro da estacao  atravez do Station_ID armazenado na EPROM

  //ser nao ouver dados na serial e a estacao nao confirmou o cadastro
  if( scommp.registred==false)
  {
   scommp.registrationRequest();
  }
  else
 {
   //desabilita a requisição de cadastro
   t0.disable();
   
   //abilita a atualização de dados dos dispositivos
   //tr.enable();

   t1.enable();
   t2.enable();
   t3.enable();
   t4.enable();
   t5.enable();
   t6.enable();
//   t7.enable();

 }
}

//==============================

void setup() {

  //! inicializando a Serial
  Serial.begin(9600);

  //! inicializando o SCOMMP
  scommp.begin (serialWrite);

  //! Adiciona sensores ao módulo de comunicação

  //Driver de Teste random_1
  //scommp.addSensor(&random_1);

  //Sensor DHT22_1
  DHT22_1.pin(4);
  scommp.addSensor (&DHT22_1);

  //Sensor LDR_GL5528_1
  LDR_GL5528_1.pin(A0);
  scommp.addSensor (&LDR_GL5528_1);

  //Sensor TP_401A_1
  TP_401A_1.pin(A1);
  scommp.addSensor (&TP_401A_1);

  //Sensor GUVA_S12D_1
  GUVA_S12D_1.pin(A2);
  scommp.addSensor (&GUVA_S12D_1);

  //Sensor Bucket_Rain_Gauge_1
  Bucket_Rain_Gauge_1.pin(6);
  scommp.addSensor (&Bucket_Rain_Gauge_1);

  //Sensor BMP085_1
  BMP085_1.init();
  scommp.addSensor (&BMP085_1);

//  //Sensor SIM28_1
//  SIM28_1.pin(2, 3);
//  scommp.addSensor (&SIM28_1);

  //! Adiciona atuadores ao módulo de comunicação
  //scommp.addActuator (new led_driver());

  //===============================
  // configuração do tempo de update

    //iniciando a task de requisição de auto registro
    //! A cada 10 segundos tenta confirmar o cadastro da estacao
    t0.enable();
    runner.addTask(t0);

    //iniciando a task de upadate do random_1
    //runner.addTask(tr);

    //iniciando a task de upadate do DHT22_1
    runner.addTask(t1);
  
    //iniciando a task de upadate do LDR_GL5528_1
    runner.addTask(t2);

    //iniciando a task de upadate do TP_401A_1
    runner.addTask(t3);

    //iniciando a task de upadate do GUVA_S12D_1
    runner.addTask(t4);

    //iniciando a task de upadate do Bucket_Rain_Gauge_1
    runner.addTask(t5);

    //iniciando a task de upadate do BMP085_1
    runner.addTask(t6);

//    //iniciando a task de upadate do SIM28_1
//    runner.addTask(t7);
}

void loop()
{ 

// se recebeu o comando par verificar a ativação
if(scommp.active == true)
{
  scommp.active = false;
  t0.enable();
}
  
//atualiza os eventos das tasks 
runner.execute();

//SIM28_1.update_serial();

}

//! Coleta os dados recebidos pela serial e envia para o tratamenteo do scommp
void serialEvent () 
{
  if (Serial.available()) {
     char c = (char)Serial.read();
     scommp.charReceived (c);
     
     lastcharTime = millis();
    }

  if (millis()-lastcharTime >= 1000 || millis()-lastcharTime < 0)
    {
      if (scommp.started())
      {
        scommp.reset();
      }
    }
}

//! Coleta a saída do módulo de comunicação e ecoa para a serial
void serialWrite (char c)
{
  //! Escreve o caractere na serial
  Serial.write (c);
}

