/**
	@file bucket_rain_gauge_driver.cpp
	@author Saulo Daniel Ferreira Pontes
	@version 1.1 07/2015

        Bucket Rain Gauge 
        - Chave Ótica interrupta C860TP CTK 22113/2214

        Volume médio que faz as básculas virarem: 9200 mm^3.
        Área da boca do funil: 16500 mm^2.
*/

#include <Arduino.h>
#include "bucket_rain_gauge_driver.h"

Bucket_Rain_Gauge_Sensor::Bucket_Rain_Gauge_Sensor() : Sensor(1)
{
}

bool Bucket_Rain_Gauge_Sensor::sense (float value[]) {

 value[0] = data[0];

 return true;
}

void Bucket_Rain_Gauge_Sensor::pin(int pin)
{
  PIN_0 = pin;

  pinMode(PIN_0, INPUT); 
}

void Bucket_Rain_Gauge_Sensor::update()
{
 //Testa se o sinal infravermelho foi interrompido
 if(!digitalRead(PIN_0) && state_control)
   {   
   //Incrementa a precipitação
   // data[0] += (float)ROCKER_VOLUME/(float)FUNNEL_AREA; 

    // o vetor data[0] estava perdendo informação assim 
    precipitation += (float)ROCKER_VOLUME/(float)FUNNEL_AREA; 
    data[0]  = precipitation;
    
   
    //Muda o estado da variável auxiliar para que se espere
    //as básculas virarem para incrementar a precipitação
    state_control = false; 
  }
 else 
  if(digitalRead(PIN_0))
  {
    //Libera a variável auxiliar para esperar a próxima virada das básculas
    state_control = true;    
  }
}

//se pararam 24 hooras de coleta o valor referente deve ser reiniciado.
void Bucket_Rain_Gauge_Sensor::reset()
{
   data[0] = 0;
   precipitation = 0;
}






