/**
	@file SIM28_driver.h
	@author Saulo Daniel Ferreira Pontes
	@version 1.1 07/2015

	Grove: GPS / SIM28
*/

#ifndef SIM28_DRIVER_H_
#define SIM28_DRIVER_H_

#include "device.h"
#include "SoftwareSerial.h"
#include "TinyGPS.h"

class SIM28_Sensor : public Sensor 
{
SoftwareSerial ss;
  
private:
       int PIN_TX;
       int PIN_RX;
       float data[8]; //data[11];
       TinyGPS gps;
       

public:
	      SIM28_Sensor();
	      bool sense (float[]);
        void pin(int rx, int tx);
        void reset();
        void update();
        void update_serial();
};


















void init_SIM28();
void SIM28_Update();

void SIM28_UpdateVar();

static void smartdelay(unsigned long ms);
//static void print_float(float val, float invalid, int len, int prec);
//static void print_int(unsigned long val, unsigned long invalid, int len);
//static void print_date(TinyGPS &gps);
//static void print_str(const char *str, int len);

class SIM28_GPS_LAT : public Sensor  {
public:
	SIM28_GPS_LAT();
	bool sense (float[]);
};

class SIM28_GPS_LON : public Sensor  {
public:
	SIM28_GPS_LON();
	bool sense (float[]);
};

class SIM28_GPS_AGE : public Sensor  {
public:
	SIM28_GPS_AGE();
	bool sense (float[]);
};

class SIM28_GPS_Speed : public Sensor  {
public:
	SIM28_GPS_Speed();
	bool sense (float[]);
};

class SIM28_GPS_Year : public Sensor  {
public:
	SIM28_GPS_Year();
	bool sense (float[]);
};

class SIM28_GPS_Month : public Sensor  {
public:
	SIM28_GPS_Month();
	bool sense (float[]);
};

class SIM28_GPS_Day : public Sensor  {
public:
	SIM28_GPS_Day();
	bool sense (float[]);
};

class SIM28_GPS_Hour : public Sensor  {
public:
	SIM28_GPS_Hour();
	bool sense (float[]);
};

class SIM28_GPS_Minute : public Sensor  {
public:
	SIM28_GPS_Minute();
	bool sense (float[]);
};

class SIM28_GPS_Second : public Sensor  {
public:
	SIM28_GPS_Second();
	bool sense (float[]);
};

class SIM28_GPS_Hundredths : public Sensor  {
public:
	SIM28_GPS_Hundredths();
	bool sense (float[]);
};

#endif /* SIM28_DRIVER_H_ */
