/**
	@file SIM28_driver.h
	@author Saulo Daniel Ferreira Pontes
	@version 1.1 07/2015

	Grove: GPS / SIM28
*/

#include "SIM28_driver.h"

float flat =0, flon=0;
unsigned long fix_age=0, speed=0;

int year;
byte month=0, day=0, hour=0, minute=0, second=0, hundredths=0;

//float flat, flon;
//unsigned long age, date, time, chars = 0;
//unsigned short sentences = 0, failed = 0;
//static const double LONDON_LAT = 51.508131, LONDON_LON = -0.128002;
//static const double BRASILIA_LAT = 46.47, BRASILIA_LON = 55.47;

SIM28_Sensor::SIM28_Sensor() : Sensor( 8 ) //Sensor( 11 )
{
}

bool SIM28_Sensor::sense (float value[]) 
{
// for(int index=0;index<11;index++)
//  {
//   value[index] = data[index];
//  }

  value[0] = data[0];
  value[1] = data[1];
  value[2] = data[2];
  value[3] = data[3];
  value[4] = data[4];
  value[5] = data[5];
  value[6] = data[6];
  value[7] = data[7];
//  value[8] = data[8];
//  value[9] = data[9];
//  value[10] = data[10];

 return true;
}

void SIM28_Sensor::pin(int rx, int tx)
{
 PIN_RX = rx;
 PIN_TX = tx;

 ss.SoftwareSerial_ConfgPins(rx, tx);

 ss.begin(9600);
}

// atualiza a coleta de dados pela SoftwareSerial
void SIM28_Sensor::update_serial()
{
  if(ss.available())
  {
   gps.encode(ss.read());
    delay(1);
  }
}

void SIM28_Sensor::update()
{
  gps.f_get_position(&flat, &flon, &fix_age);
  gps.crack_datetime(&year, &month, &day, &hour, &minute, &second, &hundredths);
 //speed = gps.speed();

 //LAT
 data[0] = flat;

 //LON
 data[1] = flon;

 //Year
 data[2] = year;

 //Month
 data[3] = month;

 //Day
 data[4] = day;

 //Hour
 data[5] = hour;

 //Minute
 data[6] = minute;

 //Second
 data[7] = second;

 //Hundredths
 //data[8] = hundredths;

  //AGE
 //data[2] = fix_age;

 //SPEED
 //data[3] = speed;

}

void SIM28_Sensor::reset()
{
 for(int index=0;index<11;index++)
  {
   data[index] = 0;
  }
}


