/**
	@file light_Sensor_LDR_GL5528.cpp
	@author Saulo Daniel Ferreira Pontes
	@version 1.0 - 03/2015

    Driver para o sensor de luz (.cpp)

    Grove - Light Sensor (LDR : GL5528)

    Resistencia aproximada do LDR:
     - Light resistance -> ~20K
     - Dark resistance -> ~1M

    Tempo de resposta: 20-30 secs
    Comprimento de pico de onda: 540 nm (Newton-metro)

 	===========================================================
    Tensão liberada pelo LDR
 	voltage = (float)analogicalValue*(5/1023);

 	Resistencia do LDR (ohms)
 	resistance = (float)(1023-analogicalValue)*10/analogicalValue;
 	===========================================================

    obs.: Por ser de baixo custo e recomendado o uso apenas
    para detecao de presenca ou alsencia de luz.
*/

#include "LDR_GL5528_driver.h"
#include <Arduino.h>

LDR_GL5528_Sensor::LDR_GL5528_Sensor() : Sensor(1) 
{
// TODO Constructor
}

bool LDR_GL5528_Sensor::sense (float value[]) 
{
 value[0] = data[0];

 return true;
}

void LDR_GL5528_Sensor::pin(int pin)
{
  PIN_0 = pin;
}

void LDR_GL5528_Sensor::update()
{
  // TODO Faz a leitura da variacao da resistencia do LDR
  // Valor da leitura analogica (0 -> 1023)
  
  int analogicalValue = analogRead(PIN_0);

  data[0] = analogicalValue;
}

void LDR_GL5528_Sensor::reset()
{
  data[0] = 0;
}





