/**
	@file BMP085_driver.H
	@author Saulo Daniel Ferreira Pontes
	@version 1.1 07/2015

	Grove: Barometer_Sensor / Bosch_BMP085
*/

#ifndef BMP085_DRIVER_H_
#define BMP085_DRIVER_H_

#include <Arduino.h>
#include "device.h"
#include "Barometer.h"

class BMP085_Sensor : public Sensor 
{
private:
       int PIN_0;
       float data[4]; //[0]:atmospheric pressure (Pa), [1]:temperature (C°), [2]: altitude (m), [3]: atmosphere (atm) 
       Barometer barometer;
       const float Pa = 101325;  // Pressure at sea level (Pa)

public:
	      BMP085_Sensor();
	      bool sense (float[]);
        void init();
        void reset();
        void update();
};

#endif /* BMP085_DRIVER_H_ */
