/**
	@file BMP085_driver.H
	@author Saulo Daniel Ferreira Pontes
	@version 1.1 07/2015

	Grove: Barometer_Sensor / Bosch_BMP085
*/

#include "BMP085_driver.h"

BMP085_Sensor::BMP085_Sensor() : Sensor(4)
{
}

void BMP085_Sensor::init()
{
 barometer.init();
}

bool BMP085_Sensor::sense (float value[]) 
{
 value[0] = data[0];
 value[1] = data[1];
 value[2] = data[2];
 value[3] = data[3];

 return true;
}

void BMP085_Sensor::update()
{
 // pressure
 data[0] = barometer.bmp085GetPressure(barometer.bmp085ReadUP());

 //temperature
 data[1] =  barometer.bmp085GetTemperature(barometer.bmp085ReadUT());

 //altitude
 data[2] = barometer.calcAltitude(data[0]);

 //atmosphere
 data[3] = data[0] / Pa;


// temperature = bmp085GetTemperature(bmp085ReadUT());
// pressure = bmp085GetPressure(bmp085ReadUP());
// altitude = myBarometer.calcAltitude(pressure); //Uncompensated caculation - in Meters
// atm = pressure / 101325;

// altitude = (float)44330 * (1 - pow(((float) pressure/Pa), 0.190295));

}

void BMP085_Sensor::reset()
{
  data[0] = 0;
  data[1] = 0;
  data[2] = 0;
  data[3] = 0;
}


